<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateAdditionalServicesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('additional_services', function (Blueprint $table) {
            $table->increments('additional_services_id')->comment('additional_services_Id');
            $table->text('additional_services_name')->comment('additional_services_name');
            $table->double('additional_services_price')->comment('additional_services_price');
            $table->integer('status')->comment('additional_services_status');
            $table->text('additional_services_description')->comment('additional_services_description');
            $table->integer('created_by');
            $table->integer('updated_by');
            $table->date('last_update_time');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('additional_services');
    }
}
