<?php

namespace Modules\AdditionalServices\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use Illuminate\Database\QueryException;
use Exception;
use Carbon\Carbon;
use Illuminate\Support\Facades\Validator;
use Modules\AdditionalServices\Models\AdditionalServiceAllocation;
use Modules\AdditionalServices\Models\AdditionalServiceKeep;
use Modules\AdditionalServices\Models\AdditionalService;
use Modules\PrimaryModule\Models\guest;
use Modules\AdditionalServices\Models\AdditionalServiceAllocationsOutsiders;
use Modules\AdditionalServices\Models\OutSideCustomer;
use Illuminate\Support\Facades\DB;
use Elibyy\TCPDF\Facades\TCPdf;
use Illuminate\Support\Facades\Session;
use App\Helper;

class AdditionalServiceAllocationController extends Controller
{
    public function AdditionalServiceAllocationView(Request $request)
    {
        $data['symble'] =Session::get('symbolC');
        $data['pagenames'] = [
            [
                'displayname'=>'Additional Service Allocation',
                'routename'=>'additional_service_allocations'
            ],
  
        ];

        $AdditionalServiceAllocation = AdditionalServiceAllocation::with(['Alocation_Details','Reservation_Details'])->get();
        $AdditionalServiceAllocation_with_outSider = AdditionalServiceAllocationsOutsiders::with(['GetOutSideCustomer','Alocation_Details_OutSiders'])->get();
        if($AdditionalServiceAllocation[0]->Reservation_Details)
        {

        $data['Additional_Service_Allocation_with_outSider'] = $AdditionalServiceAllocation_with_outSider;
        $data['Additional_Service_Allocation'] = $AdditionalServiceAllocation;
        return view('additionalservices::pages.additional_service_allocations',$data);

        }
        else
        {
           $data = [
                   'status'=>'400',
                   'error_status'=>'1',
                   'msg'=>'Please Make Reservation'
               ];
   
               return back()->with('status',$data);
        }
    }


    public function CustomerAddAddtional(Request $request)
    {

        $rules = [

            'fname' => 'required',
            'lname' => 'required',
            'id_number' => 'required',
            'Cnumber' => 'required',
            'Cemail' => 'required',
            
        ];
        $customMessages = [


            'fname.required' => 'enter customer first name',
            'lname.required' => 'enter customer last name',
            'id_number.required' => 'enter id card number',
            'Cnumber.required' => 'enter contact number',
            'Cemail.required' => 'enter email address',
        ];

        $validation = Validator::make($request->all(), $rules, $customMessages)->validate();
        

            $fname = $request->input('fname');
            $lname = $request->input('lname');
            $id_number = $request->input('id_number');
            $Cnumber = $request->input('Cnumber');
            $Cemail = $request->input('Cemail');
            $status = '1'; 
            $created_by = '1'; 
            $last_upadte_time = Carbon::now();

                try{
    
                    OutSideCustomer::insert(['customer_first_name'=>$fname,'customer_last_name' => $lname, 'customer_Id_card_number' => $id_number,'customer_contact_number' => $Cnumber, 'customer_address' => $Cemail, 'sts' => $status, 'created_by' => $created_by, 'last_update_time' => $last_upadte_time]);

                    $data = [
                    'status'=>'200',
                    'error_status'=>'0',
                    'msg'=>'Customer add successfully'
                     ];
                    return redirect()->route('additional_service_allocationsUpdate_update_add_edit')->with('status',$data);
                }catch (QueryException $e) 
                {
                  
                    $data = [
                        'status'=>'200',
                        'error_status'=>'1',
                        'msg'=>'Customer add failed qry'
                    ];
                    return redirect()->route('additional_service_allocationsUpdate_update_add_edit')->with('status',$data);
                }
                catch(Exception $e){
                              
                    // if something went wrong
        
                    $data = [
                        'status'=>'400',
                        'error_status'=>'2',
                        'msg'=>' Customer add faild'
                    ];
        
                    return redirect('additional_service_allocationsUpdate_update_add_edit')->with('status',$data);
        
                }
                  
    }

    public function Outsiders_AdditionalServiceAllocationUpdateEdit(Request $request)
    {
        $request['pagenames'] = [
            [
                'displayname'=>'Additional Service Allocation',
                'routename'=>'additional_service_allocations'
            ],

            [
                'displayname'=>'Add / Edit Additional Service Allocation',
                'routename'=>'additional_service_allocations_add_edit'
            ],
  
        ];
        $request['pre_link'] = "job_housekeeping_view";
        
        if(isset($request->cid)){

            try{
 
                $ID=$request->cid; 
                $ASID=$request->casid;
                $AID=$request->caid;


                $Customer=OutSideCustomer::get()->sortByDesc('id');
                $AdditionalService=AdditionalService::get()->sortByDesc('additional_services_id');
                $AdditionalService_with_ID=AdditionalService::where('additional_services_id',$ASID)->first();
                $AdditionalKeep_with_ID=AdditionalServiceKeep::where('allocations_keeps_id',$AID)->first();;
                $AdditionalServiceAllocation_with_outSider = AdditionalServiceAllocationsOutsiders::with(['GetOutSideCustomer','Alocation_Details_OutSiders'])->get();
                $AdditionalServiceAllocation_with_outSider_with_ID = AdditionalServiceAllocationsOutsiders::with(['GetOutSideCustomer','Alocation_Details_OutSiders'])->where('allocations_id_outsiders',$ID)->first();

                $data['Additional_Service_Allocation_with_outSider_with_ID'] = $AdditionalServiceAllocation_with_outSider_with_ID;
                $data['Additional_Keep_With_ID'] = $AdditionalKeep_with_ID;
                $data['Additional_Service_with_ID'] = $AdditionalService_with_ID;
                $data['Additional_Service_Allocation_with_outSider'] = $AdditionalServiceAllocation_with_outSider;
                $data['Additional_Service'] = $AdditionalService;
                $data['Customer'] = $Customer;

                return view('additionalservices::pages.additional_service_allocations_add_edit_outsiders',$data);


            }catch(Exception $e){
               
               
               $data = [
                   'status'=>'400',
                   'error_status'=>'1',
                   'msg'=>'something went wrong'
               ];
   
               return redirect('job_housekeeping_view')->with('status',$data);
   
            }
 
        }else{
        
            $Customer=OutSideCustomer::get()->sortByDesc('id');
            $AdditionalServiceAllocation = AdditionalServiceAllocation::with(['Alocation_Details','Reservation_Details'])->get();
            $AdditionalServiceAllocation_with_outSider = AdditionalServiceAllocationsOutsiders::with(['GetOutSideCustomer','Alocation_Details_OutSiders'])->get();
            $AdditionalService=AdditionalService::get()->sortByDesc('additional_services_id');

            $request['Additional_Service_Allocation_with_outSider'] = $AdditionalServiceAllocation_with_outSider;
            $request['Additional_Service_Allocation'] = $AdditionalServiceAllocation;
            $request['Additional_Service'] = $AdditionalService;
            $request['Customer'] = $Customer;
           return view('additionalservices::pages.additional_service_allocations_add_edit_outsiders',$request);
        }

    }

    public function OutSider_AdditionalServiceAllocationAddUpdate(Request $request)
    {

            $rules = [

                'Additional_Service_Name' => 'required',
                'Additional_Hours' => 'required',
                'Additional_Items' => 'required',
                'Additional_Date' => 'required',
                'Additional_Descriptione' => 'required',
                
            ];
            $customMessages = [


                'Additional_Service_Name.required' => 'Select Services Type',
                'Additional_Hours.required' => 'Enter Number of Hours',
                'Additional_Items.required' => 'Enter Number of Items',
                'Additional_Date.required' => 'Select Date',
                'Additional_Descriptione.required' => 'Description Required',
            ];

            $validation = Validator::make($request->all(), $rules, $customMessages)->validate();
            

                $Additional_Service_Cutomer = $request->input('Additional_Service_Cutomer');
                $Additional_Service_Name = $request->input('Additional_Service_Name');
                $Additional_Hours = $request->input('Additional_Hours');
                $Additional_Items = $request->input('Additional_Items');
                $Additional_Date = $request->input('Additional_Date');
                $check_raido = $request->input('checked_box');
                $deposit_amount = $request->input('deposit_amount');
                $Additional_Descriptione = $request->input('Additional_Descriptione');
                $allocations_keeps_idd = $request->input('allKeepId');
                $allocations_idd = $request->input('allallocationid');
                $cutomer_type='2';
                $status = '1';
                $created_by = '1'; 
                $updated_by = '1';  
                $updated_at = Carbon::now();

                if ($allocations_keeps_idd != null && $allocations_keeps_idd != "") {

                    try{

                        AdditionalServiceAllocationsOutsiders::where('allocations_id_outsiders', $Additional_Service_Cutomer)
                            ->update([ 'diposit_type' => $check_raido,'diposit_amount' => $deposit_amount,'updated_by' => $updated_by, 'last_update_time' => $updated_at]);

                        AdditionalServiceKeep::where('allocations_keeps_id', $allocations_keeps_idd)
                        ->update(['allocations_id'=>$allocations_idd,'additional_services_id' => $Additional_Service_Name, 'duration' => $Additional_Hours,'count' => $Additional_Items, 'allocations_date_date' => $Additional_Date, 'Description' => $Additional_Descriptione, 'sts' => $status]);

                        $data = [
                        'status'=>'200',
                        'error_status'=>'0',
                        'msg'=>'Job type add successfully'
                         ];
                        return redirect()->route('additional_service_allocations_add_edit_outsiders')->with('status',$data);
                    }catch (QueryException $e) 
                    {
                      
                        $data = [
                            'status'=>'200',
                            'error_status'=>'1',
                            'msg'=>'Job type add failed qry'
                        ];
                        return redirect()->route('additional_service_allocations_add_edit_outsiders')->with('status',$data);
                    }
                    catch(Exception $e){
                                  
                        // if something went wrong
            
                        $data = [
                            'status'=>'400',
                            'error_status'=>'2',
                            'msg'=>' addiional service allocation edit faild'
                        ];
            
                        return redirect('additional_service_allocations_add_edit_outsiders')->with('status',$data);
            
                    }
                } else {

                    try{
                    

                        $validate=AdditionalServiceAllocationsOutsiders::where('outside_customer_id',$Additional_Service_Cutomer)->first();
                        if($validate)
                        {
                            $deposit=$validate->diposit_amount;
                            $total_deposit=$deposit+$deposit_amount;
                            $allocationid_get=$validate->allocations_id_outsiders;

                            AdditionalServiceAllocationsOutsiders::where('allocations_id_outsiders', $allocationid_get)
                            ->update([ 'diposit_amount' => $total_deposit,'updated_by' => $updated_by, 'last_update_time' => $updated_at]);

                            AdditionalServiceKeep::insert(['allocations_id' => $allocationid_get, 'additional_services_id' => $Additional_Service_Name,'cutomer_type' => $cutomer_type, 'duration' => $Additional_Hours,'count' => $Additional_Items, 'allocations_date_date' => $Additional_Date, 'Description' => $Additional_Descriptione, 'sts' => $status]);

                        }
                        else{

                            $allocationid = AdditionalServiceAllocationsOutsiders::insertGetId(['outside_customer_id' => $Additional_Service_Cutomer, 'service_types' => $Additional_Service_Name, 'diposit_type' => $check_raido, 'diposit_amount' => $deposit_amount, 'created_by' => $created_by,'updated_by' => $updated_by, 'last_update_time' => $updated_at]);

                            AdditionalServiceKeep::insert(['allocations_id' => $allocationid, 'additional_services_id' => $Additional_Service_Name,'cutomer_type' => $cutomer_type, 'duration' => $Additional_Hours,'count' => $Additional_Items, 'allocations_date_date' => $Additional_Date, 'Description' => $Additional_Descriptione, 'sts' => $status]);

                        }
                    
                        $data = [
                        'status'=>'200',
                        'error_status'=>'0',
                        'msg'=>'Job type add successfully'
                         ];
                        return redirect()->route('additional_service_allocations_add_edit_outsiders')->with('status',$data);
                    }catch (QueryException $e) 
                    {
       
                        $data = [
                            'status'=>'200',
                            'error_status'=>'1',
                            'msg'=>'Job type add failed qry'
                        ];
                        return redirect()->route('additional_service_allocations_add_edit_outsiders')->with('status',$data);
                    }
                    catch(Exception $e){
                                 
                        // if something went wrong
            
                        $data = [
                            'status'=>'400',
                            'error_status'=>'2',
                            'msg'=>'Job type add fail '
                        ];
            
                        return redirect('additional_service_allocations_add_edit_outsiders')->with('status',$data);
            
                    }
                }
            
    }
    public function AdditionalServiceAllocationUpdateEdit(Request $request)
    {
        $data['symble'] =Session::get('symbolC');
        $data['pagenames'] = [
            [
                'displayname'=>'Additional Service Allocation',
                'routename'=>'additional_service_allocations'
            ],

            [
                'displayname'=>'Add / Edit Additional Service Allocation',
                'routename'=>'additional_service_allocations_add_edit'
            ],
  
        ];
        $data['pre_link'] = "job_housekeeping_view";
        
        
        if(isset($request->id)){

            try{
 
                $ID=$request->id; 
                $ASID=$request->asid;
                $AID=$request->aid;
                $AdditionalServiceAllocation_With_ID = AdditionalServiceAllocation::with(['Alocation_Details','Reservation_Details'])->where('allocations_id',$ID)->first();
                $AdditionalServiceAllocation = AdditionalServiceAllocation::with(['Alocation_Details','Reservation_Details'])->get();
                $guest=Guest::get()->sortByDesc('id');
                $AdditionalService=AdditionalService::get()->sortByDesc('additional_services_id');
                $AdditionalService_with_ID=AdditionalService::where('additional_services_id',$ASID)->first();
                $AdditionalKeep_with_ID=AdditionalServiceKeep::where('allocations_keeps_id',$AID)->first();;

                $data['Additional_Keep_With_ID'] = $AdditionalKeep_with_ID;
                $data['Additional_Service_with_ID'] = $AdditionalService_with_ID;
                $data['Additional_Service_Allocation_With_ID'] = $AdditionalServiceAllocation_With_ID;
                $data['Additional_Service_Allocation'] = $AdditionalServiceAllocation;
                $data['Additional_Service'] = $AdditionalService;
                $data['guest'] = $guest;

                return view('additionalservices::pages.additional_service_allocations_add_edit',$data);


            }catch(Exception $e){
               
                
               $data = [
                   'status'=>'400',
                   'error_status'=>'1',
                   'msg'=>'something went wrong'
               ];
   
               return redirect('job_housekeeping_view')->with('status',$data);
   
            }
 
        }else{
        
            $AdditionalServiceAllocation = AdditionalServiceAllocation::with(['Alocation_Details','Reservation_Details'])->get();

            $guest=Guest::get()->sortByDesc('id');
            $AdditionalService=AdditionalService::get()->sortByDesc('additional_services_id');

            
            $data['Additional_Service_Allocation'] = $AdditionalServiceAllocation;
            $data['Additional_Service'] = $AdditionalService;
            $data['guest'] = $guest;

           return view('additionalservices::pages.additional_service_allocations_add_edit',$data);
        }

    }



    public function AdditionalServiceAllocationAddUpdate(Request $request)
    {

            $rules = [

                'Additional_Service_Name' => 'required',
                'Additional_Hours' => 'required',
                'Additional_Items' => 'required',
                'Additional_Date' => 'required',
                'Additional_Descriptione' => 'required',
                
            ];
            $customMessages = [


                'Additional_Service_Name.required' => 'Select Services Type',
                'Additional_Hours.required' => 'Enter Number of Hours',
                'Additional_Items.required' => 'Enter Number of Items',
                'Additional_Date.required' => 'Select Date',
                'Additional_Descriptione.required' => 'Description Required',
            ];

            $validation = Validator::make($request->all(), $rules, $customMessages)->validate();
            

                $Additional_Service_Guest = $request->input('Additional_Service_Guest');
                $Additional_Service_Name = $request->input('Additional_Service_Name');
                $Additional_Hours = $request->input('Additional_Hours');
                $Additional_Items = $request->input('Additional_Items');
                $Additional_Date = $request->input('Additional_Date');
                $Additional_Time = $request->input('Additional_Time');
                $Additional_Descriptione = $request->input('Additional_Descriptione');
                $allocations_keeps_idd = $request->input('allKeepId');
                $allocations_idd = $request->input('allallocationid');
                $cutomer_type = '1';
                $status = '1'; 
                $created_by = '1'; 
                $updated_by = '1';  
                $updated_at = Carbon::now();

                if ($allocations_keeps_idd != null && $allocations_keeps_idd != "") {

                    try{
        
                        AdditionalServiceKeep::where('allocations_keeps_id', $request->input('allKeepId'))
                        ->update(['allocations_id'=>$allocations_idd,'additional_services_id' => $Additional_Service_Name,'cutomer_type' => $cutomer_type, 'duration' => $Additional_Hours,'count' => $Additional_Items, 'allocations_date_date' => $Additional_Date, 'Description' => $Additional_Descriptione, 'sts' => $status]);

                        $data = [
                        'status'=>'200',
                        'error_status'=>'0',
                        'msg'=>'Job type add successfully'
                         ];
                        return redirect()->route('additional_service_allocations_view_add_edit')->with('status',$data);
                    }catch (QueryException $e) 
                    {
                      
                        $data = [
                            'status'=>'200',
                            'error_status'=>'1',
                            'msg'=>'Job type add failed qry'
                        ];
                        return redirect()->route('additional_service_allocations_view_add_edit')->with('status',$data);
                    }
                    catch(Exception $e){
                                  
                        // if something went wrong
            
                        $data = [
                            'status'=>'400',
                            'error_status'=>'2',
                            'msg'=>' addiional service allocation edit faild'
                        ];
            
                        return redirect('additional_service_allocations_view_add_edit')->with('status',$data);
            
                    }
                } else {

                    try{
                    
                        $validate=AdditionalServiceAllocation::where('room_reservations_id',$Additional_Service_Guest)->first();
                        $allocationid_get=$validate->allocations_id;
                        $room_reservations=$validate->room_reservations_id;
                        if($room_reservations == 'null')
                        {
                            $allocationid = AdditionalServiceAllocation::insertGetId(['room_reservations_id' => $Additional_Service_Guest, 'service_types' => $Additional_Service_Name, 'created_by' => $created_by,'updated_by' => $updated_by, 'last_update_time' => $updated_at]);

                            AdditionalServiceKeep::insert(['allocations_id' => $allocationid, 'additional_services_id' => $Additional_Service_Name,'cutomer_type' => $cutomer_type, 'duration' => $Additional_Hours,'count' => $Additional_Items, 'allocations_date_date' => $Additional_Date, 'Description' => $Additional_Descriptione, 'sts' => $status]);

                        }
                        else{

                            AdditionalServiceKeep::insert(['allocations_id' => $allocationid_get, 'additional_services_id' => $Additional_Service_Name,'cutomer_type' => $cutomer_type, 'duration' => $Additional_Hours,'count' => $Additional_Items, 'allocations_date_date' => $Additional_Date, 'Description' => $Additional_Descriptione, 'sts' => $status]);

                        }
                    
                        $data = [
                        'status'=>'200',
                        'error_status'=>'0',
                        'msg'=>'Job type add successfully'
                         ];
                        return redirect()->route('additional_service_allocations_view_add_edit')->with('status',$data);
                    }catch (QueryException $e) 
                    {
                      
                        $data = [
                            'status'=>'200',
                            'error_status'=>'1',
                            'msg'=>'Job type add failed qry'
                        ];
                        return redirect()->route('additional_service_allocations_view_add_edit')->with('status',$data);
                    }
                    catch(Exception $e){
                                   
                        // if something went wrong
            
                        $data = [
                            'status'=>'400',
                            'error_status'=>'2',
                            'msg'=>'Job type add fail '
                        ];
            
                        return redirect('additional_service_allocations_view_add_edit')->with('status',$data);
            
                    }
                }
            
    }

    public function Print_AdditionalServiceAllocationOutSiders(Request $request)
    {
        
        $request['pagenames'] = [
            [
                'displayname'=>'Additional Service Allocation',
                'routename'=>'additional_service_allocations'
            ],
  
        ];
        
        $ID=$request->cid; 
        $ASID=$request->casid; 

        $AdditionalServiceAllocation = AdditionalServiceAllocation::with(['Alocation_Details','Reservation_Details'])->get();


        $AdditionalServiceAllocation_with_outSider_with_ID = AdditionalServiceAllocationsOutsiders::with(['GetOutSideCustomer','Alocation_Details_OutSiders'])->where('allocations_id_outsiders',$ID)->first();

        $durationpluck=AdditionalServiceKeep::where([['allocations_id','=',$ID],['cutomer_type','=','2']])->get()->pluck('duration')->toArray();
        $countpluck=AdditionalServiceKeep::where([['allocations_id','=',$ID],['cutomer_type','=','2']])->get()->pluck('count')->toArray();
        $totalitems=array_map(function($x, $y) { return $x * $y; },
                   $durationpluck, $countpluck);
        $discount_amount=$AdditionalServiceAllocation_with_outSider_with_ID->diposit_amount;

        
        $price_list = DB::table('additional_service_allocations_outsiders')
            ->join('additional_service_keeps', 'additional_service_allocations_outsiders.allocations_id_outsiders', '=', 'additional_service_keeps.allocations_id')
            ->join('additional_services', 'additional_service_keeps.additional_services_id', '=', 'additional_services.additional_services_id')
            ->where([['allocations_id','=',$ID],['cutomer_type','=','2']])
            ->get()->pluck('additional_services_price')->toArray();

            $subtotal=array_map(function($x, $y) { return $x * $y; },
            $totalitems, $price_list);

            $total=0;
            foreach($subtotal as $sub){
                $total += $sub;
            }

            
        $totalwithdiscount= $total-$discount_amount;
        if($AdditionalServiceAllocation[0]->Reservation_Details)
        {

        $data['totalwithdiscount'] = $totalwithdiscount;
        $data['total'] = $total;
        $data['subtotal'] = $subtotal;
        $data['AdditionalServiceAllocation_with_outSider'] = $AdditionalServiceAllocation_with_outSider_with_ID;
        $data['Additional_Service_Allocation'] = $AdditionalServiceAllocation;
        return view('additionalservices::pages.additional_service_allocations_Invoice',$data);

        }
        else
        {
           $data = [
                   'status'=>'400',
                   'error_status'=>'1',
                   'msg'=>'Please Make Reservation' 
               ];
   
               return back()->with('status',$data);
        }
    }

    public function Print_PDF(Request $request)
    {
        $ID=$request->cid; 
        $ASID=$request->casid; 
        $request['symble'] =Session::get('symbolC');
        $request['val']=Helper::GetSystemUserCurrency_wv();
        $AdditionalServiceAllocation = AdditionalServiceAllocation::with(['Alocation_Details','Reservation_Details'])->get();
        $AdditionalServiceAllocation_with_outSider_with_ID = AdditionalServiceAllocationsOutsiders::with(['GetOutSideCustomer','Alocation_Details_OutSiders'])->where('allocations_id_outsiders',$ID)->first();
        $durationpluck=AdditionalServiceKeep::where([['allocations_id','=',$ID],['cutomer_type','=','2']])->get()->pluck('duration')->toArray();
        $countpluck=AdditionalServiceKeep::where([['allocations_id','=',$ID],['cutomer_type','=','2']])->get()->pluck('count')->toArray();

        $totalitems=array_map(function($x, $y) { return $x * $y; },
                   $durationpluck, $countpluck);
        $discount_amount=$AdditionalServiceAllocation_with_outSider_with_ID->diposit_amount;

        
        $price_list = DB::table('additional_service_allocations_outsiders')
            ->join('additional_service_keeps', 'additional_service_allocations_outsiders.allocations_id_outsiders', '=', 'additional_service_keeps.allocations_id')
            ->join('additional_services', 'additional_service_keeps.additional_services_id', '=', 'additional_services.additional_services_id')
            ->where([['allocations_id','=',$ID],['cutomer_type','=','2']])
            ->get()->pluck('additional_services_price')->toArray();

            $subtotal=array_map(function($x, $y) { return $x * $y; },
            $totalitems, $price_list);

            $total=0;
            foreach($subtotal as $sub){
                $total += $sub;
            }

            
        $totalwithdiscount= $total-$discount_amount;
        if($AdditionalServiceAllocation[0]->Reservation_Details)
        {
        $data['totalwithdiscount'] = $totalwithdiscount;
        $data['total'] = $total;
        $data['subtotal'] = $subtotal;
        $data['AdditionalServiceAllocation_with_outSider'] = $AdditionalServiceAllocation_with_outSider_with_ID;
        $data['Additional_Service_Allocation'] = $AdditionalServiceAllocation;
         $test= view('additionalservices::pages.addtional_service_print',$data);

        }
        else
        {
           $data = [
                   'status'=>'400',
                   'error_status'=>'1',
                   'msg'=>'Invoice error'
               ];
   
               return back()->with('status',$data);
        }



        $index = 0;
        foreach ($AdditionalServiceAllocation_with_outSider_with_ID->Alocation_Details_OutSiders as                $Additional_Service_outSider)
        {
                foreach ($Additional_Service_outSider->Additional_Services as $Additional_Services)
                {
                      $addname=$Additional_Services->additional_services_name;
                }              
                foreach ($Additional_Service_outSider->Additional_Services as $Additional_Services){

                        $addprice=$Additional_Services->additional_services_price;

                }
                $duration=$Additional_Service_outSider->duration;
                $count= $Additional_Service_outSider->count;
                $subtota=$subtotal[$index];
   
            $index++;
            }

            if($AdditionalServiceAllocation_with_outSider_with_ID->diposit_type == 0)
            {
                $TypeName='No Disposition';
            }

            elseif($AdditionalServiceAllocation_with_outSider_with_ID->diposit_type == 1){
                $TypeName='National Identity Card';
            }
            elseif($AdditionalServiceAllocation_with_outSider_with_ID->diposit_type == 2){
                $TypeName='Passport';
            }
            elseif($AdditionalServiceAllocation_with_outSider_with_ID->diposit_type == 3){
                $TypeName='Driving License';
            }

        $printdata = '<table style="height: 90px; width: 100%; border-collapse: collapse; border-style: solid;" border="1">
        <tbody>
            <tr style="height: 18px;">
                <td style="width: 100%; height: 18px; font-size: 20px; text-align: center;">INVOICE</td>
    
            </tr>
            <tr style="height: 30px;">
                <td style="width: 100%; height: 18px; font-size: 10px; text-align: right;">
                    Hotel Name<br>
                    hotelemail@gmail.com<br>
                    hotel adress
                    &nbsp;</td>
            </tr>
            <tr style="height: 18px;">
                <td style="width: 100%; height: 18px;">Client Details<br><span
                        style="font-size: 10px">'.$AdditionalServiceAllocation_with_outSider_with_ID->GetOutSideCustomer->customer_first_name.$AdditionalServiceAllocation_with_outSider_with_ID->GetOutSideCustomer->customer_last_name.'</span><br><span
                        style="font-size: 10px">'.$AdditionalServiceAllocation_with_outSider_with_ID->GetOutSideCustomer->customer_contact_number.'</span><br><span
                        style="font-size: 10px">'.$AdditionalServiceAllocation_with_outSider_with_ID->GetOutSideCustomer->customer_address.'</span>
                </td>
            </tr>
        </tbody>
    </table>
    <table style="border-collapse: collapse; width: 100%; height: 36px;" border="1">
        <thead>
            <tr style="height: 10px;">
                <th style="width: 50%; height: 10px; font-size: 9px; text-align: center;">Service</th>
                <th style="width: 12.5%;height: 10px; font-size: 9px; text-align: center;">Number of Hours</th>
                <th style="width: 12.5%;height: 10px; font-size: 9px; text-align: center;">Number of Items</th>
                <th style="width: 12.5%; height: 10px; font-size: 9px; text-align: center;">Unit Price</th>
                <th style="width: 12.5%; height: 10px; font-size: 9px; text-align: center;">Subtotal</th>
            </tr>
        </thead>
    
        <tbody>
           //
           <tr style="height: 10px;">
           <td style="width: 50%; height: 8px; font-size: 8px; text-align: center;">
           '.$addname.'
           </td>
           <td style="width: 12.5%; height: 8px; font-size: 8px; text-align: center;">
           '.$duration.'
            </td>
            <td style="width: 12.5%; height: 8px; font-size: 8px; text-align: center;">
               '.$count.'
               </td>
               <td style="width: 12.5%; height: 8px; font-size: 8px; text-align: center;">
               '.$addprice.'
               </td>
               <td style="width: 12.5%; height: 8px; font-size: 8px; text-align: center;">
               '.$subtota.'
               </td>

        </tbody>
    </table>
    <table style="border-collapse: collapse; width: 100%;" border="1">
        <tbody>
    
            <tr style="height: 18px;">
                <td style="width: 50%; height: 18px;"><br>Deposit Amount<br><span style="font-size: 10px">RS:'.$AdditionalServiceAllocation_with_outSider_with_ID->diposit_amount.'.00</span><br><span
                        style="font-size: 10px">Deposit :'.$TypeName.'

                    </span>
                </td>
                <td style="width: 50%; height: 18px; text-align: right;"><br>Total<br><span
                        style="font-size: 10px">Rs.'.$total.'.00</span><br><br>Total With Deposit<br><span
                        style="font-size: 12px">Rs.'.$totalwithdiscount.'.00</span>
                </td>
            </tr>
        </tbody>
    </table>
    ';

        TCPdf::SetTitle('Additional Service Invoice');
        TCPdf::AddPage();
        TCPdf::writeHTML($test, true, false, true, false, '');
 
        TCPdf::Output(uniqid().'_Additional_Service_Invoice.pdf', 'D');
        TCPdf::SetTitle('Additional Service Invoice');
        
        
    }
}
