<?php

namespace Modules\AdditionalServices\Http\Controllers;
use App\Http\Controllers\Controller;
use Modules\AdditionalServices\Models\AdditionalService; 
use Illuminate\Http\Request; 
use Illuminate\Database\QueryException;
use Exception;
use Carbon\Carbon;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Session;
use App\Helper;
use module_helper;

class AdditionalServiceContrpller extends Controller
{
    public function AdditionalServicesViewAddEdit(Request $request)
    {
        $data['symble'] =Session::get('symbolC');
        $data['pagenames'] = [
            [
                'displayname'=>'Additional Services View / Add / Edit',
                'routename'=>'additional_service'
            ],
  
        ];
        $data['pre_link'] = "job_housekeeping_view";
        if(isset($request->id)){

            try{
   

                $additional_services_id = $request->id;
                $additional_services = AdditionalService::get()->sortByDesc('additional_services_id');
                $additional_services_id = AdditionalService::get()->find($additional_services_id);

                foreach ($additional_services as $row) {
                    $additional_services_price=Helper::GetSystemUserCurrency_convertion($row->additional_services_price);
                    }
                    $request['additional_services_price'] = $additional_services_price;
                $data['additional_services'] = $additional_services;
                $data['additional_service_with_id'] = $additional_services_id;
                return view('additionalservices::pages.additional_service',$data);

   
            }catch(Exception $e){
                
               $data = [
                   'status'=>'400',
                   'error_status'=>'1',
                   'msg'=>'something went wrong'
               ];
   
               return back()->with('status',$data);
   
            }
 
        }else{
            
            //module_helper::checkfiles();
            //dd($request->session()->get('Additional_Service'));

            $additional_services = AdditionalService::get()->sortByDesc('additional_services_id');
            foreach ($additional_services as $row) {
            $additional_services_price[]=Helper::GetSystemUserCurrency_convertion($row->additional_services_price);

            }
            $data['additional_services'] = $additional_services;
            $data['additional_services_price'] = $additional_services_price;
            return view('additionalservices::pages.additional_service',$data);
        }

    }
    // this method add edit addtional service blade with data
    public function AdditionalServicesAddUpdate(Request $request)
    {

            $rules = [

                'additional_services_name' => 'required',
                'additional_services_price' => 'required',
                'additional_services_description' => 'required'
            ];
            $customMessages = [

                'additional_services_name.required' => 'Services Name Required',
                'additional_services_price.required' => 'Services Price Required',
                'additional_services_description.required' => 'Description Required',
            ];

            $validation = Validator::make($request->all(), $rules, $customMessages)->validate();
           
                
                $additional_services_id = $request->input('additional_services_id');
                $additional_services_name = $request->input('additional_services_name');
                $additional_services_price_get = $request->input('additional_services_price');
                $additional_services_price=Helper::GetSystemUserCurrency_convertion($additional_services_price_get);
                $additional_services_description = $request->input('additional_services_description');
                $status='1';
                $updated_by = "1";
                $created_by = "1";
                $updated_at = Carbon::now();

                if ($additional_services_id != null && $additional_services_id != "") {

                    try{
                        AdditionalService::where('additional_services_id', $additional_services_id)
                        ->update(['additional_services_name' => $additional_services_name, 'additional_services_price' => $additional_services_price, 'status' => $status, 'additional_services_description' => $additional_services_description,'updated_by' => $updated_by, 'created_by' => $created_by, 'last_update_time' => $updated_at]);

                        $data = [ 
                            'status'=>'200',
                            'error_status'=>'0',
                            'msg'=>'Job type update successfully'
                        ];
                        return redirect()->route('additional_service')->with('status',$data);


                    }catch (QueryException $e) {
                        $data = [
                            'status'=>'200',
                            'error_status'=>'1',
                            'msg'=>'Job type update successfully'
                        ];
                        return redirect()->route('additional_service')->with('status',$data);
                    }
                    catch(Exception $e){
                                    
                        // if something went wrong
            
                       
                        $data = [
                            'status'=>'400',
                            'error_status'=>'2',
                            'msg'=>'room type update failed'
                        ];
            
                        return redirect('additional_service')->with('status',$data);
            
                    }
                } else {

                    try{
                    
                        AdditionalService::insert(['additional_services_name' => $additional_services_name, 'additional_services_price' => $additional_services_price, 'status' => $status, 'additional_services_description' => $additional_services_description,'updated_by' => $updated_by, 'created_by' => $created_by, 'last_update_time' => $updated_at]);
                    
                        $data = [
                        'status'=>'200',
                        'error_status'=>'0',
                        'msg'=>'Job type add successfully'
                         ];
                        return redirect()->route('additional_service')->with('status',$data);
                    }catch (QueryException $e) 
                    {
                      
                        $data = [
                            'status'=>'200',
                            'error_status'=>'1',
                            'msg'=>'Job type add failed qry'
                        ];
                        return redirect()->route('additional_service')->with('status',$data);
                    }
                    catch(Exception $e){
                             
                        // if something went wrong
            
                        $data = [
                            'status'=>'400',
                            'error_status'=>'2',
                            'msg'=>'Job type add fail '
                        ];
            
                        return redirect('additional_service')->with('status',$data);
            
                    }
                }
            
    }
}
