<?php

namespace Modules\AdditionalServices\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Modules\AdditionalServices\Models\AdditionalServiceKeep;
use Modules\PrimaryModule\Models\roomReservation;

class AdditionalServiceAllocation extends Model
{
    protected $table = 'additional_service_allocations';
    protected $filltable=['allocations_id','room_reservations_id','service_types','created_by','updated_by','last_update_time'];
    public $timestamps = false;
    protected $primaryKey = 'allocations_id';
    use HasFactory;

    public function Alocation_Details(){
        return $this->hasMany(AdditionalServiceKeep::class,'allocations_id','allocations_id')->where('cutomer_type', '1')->with('Additional_Services');
    }
    public function Reservation_Details(){
        return $this->hasOne(RoomReservation::class,'id','room_reservations_id')->with(['get_guest']);
    }
    
}
