@extends('../layout/form-home-layout')

@section('form-name', 'Additional Services Type')

@section('form-area')




    <div class="p-5" id="form-validation">
        <form class="validate-form" id="frmdt" method="POST" action="{{ route('additional_service_view_add_update') }}">
            @csrf
            <div class="grid grid-cols-12 gap-5">
                <div class="col-span-12 xl:col-span-8">

                    <input hidden type="text" name="additional_services_id" id="additional_services_id"
                        class="input w-full border mt-2"
                        value="{{ isset($additional_service_with_id) ? $additional_service_with_id->additional_services_id : '' }}">


                    <div class="intro-y col-span-12 sm:col-span-6 input-form">
                        <div class="mb-2">Additional Services Name</div>
                        <input type="text" id="additional_services_name" name="additional_services_name"
                            class="input w-full border flex-1" placeholder="Pool Service" required
                            value="{{ isset($additional_service_with_id) ? $additional_service_with_id->additional_services_name : '' }}">
                    </div>
                    <br>
                    <div class="intro-y col-span-12 sm:col-span-6 input-form">
                        <div class="mb-2">Additional Services Price Rs:</div>
                        <input type="number" id="additional_services_price" name="additional_services_price"
                            class="input w-full border flex-1" placeholder="{{ $symble }}0.00" required
                            value="{{ isset($additional_service_with_id) ? $additional_service_with_id->additional_services_price : '' }}">
                    </div>
                    <div class="mt-3">
                        <label>Description</label>
                        <textarea name="additional_services_description" id="additional_services_description"
                            class="input w-full border mt-2 bg-gray-100"
                            placeholder="">{{ isset($additional_service_with_id) ? $additional_service_with_id->additional_services_description : '' }}</textarea>
                    </div>
                </div>

            </div>

            <button type="button" class="button w-20 bg-theme-9 text-white mt-3" style="margin-top: 10%;"
                id="savebtn">Save</button>

        </form>
    </div>

@endsection


@section('table-area')

    <div class="p-5" id="basic-table">
        <div class="preview">
            <div class="overflow-x-auto">

                <table class="table table-report -mt-2" id="dttbl">
                    <thead>
                        <tr>
                            <th class="whitespace-no-wrap ">#</th>
                            <th class="whitespace-no-wrap">Name</th>
                            <th class=" whitespace-no-wrap">Price</th>
                            <th class=" whitespace-no-wrap">Status</th>
                            <th class=" whitespace-no-wrap">action</th>
                        </tr>
                    </thead>
                    <tbody id="data_table">
                        @if (count($additional_services) > 0)
                            <?php $index = 0; ?>
                            @foreach ($additional_services as $additional_services)
                                <tr class="intro-x">
                                    <td>
                                        <div class="font-medium whitespace-no-wrap ">
                                            {{ $additional_services->additional_services_id }}</div>
                                    </td>
                                    <td>
                                        <div class="font-medium whitespace-no-wrap">
                                            {{ $additional_services->additional_services_name }}</div>
                                    </td>
                                    <td>
                                        <div class="font-medium whitespace-no-wrap">

                                            {{ $additional_services_price[$index] }}</div>
                                    </td>
                                    <td class="w-40">
                                        @if ($additional_services->status == '1')
                                            <div class="flex button w-30 bg-theme-9 text-white">
                                                <i data-feather="check-square" class="w-4 h-4 mr-2"></i>Active
                                            </div>
                                        @else
                                            <div class="flex button w-30 bg-theme-11 text-white ">
                                                <i data-feather="check-square" class="w-4 h-4 mr-2"> </i>
                                                Inactive
                                            </div>
                                        @endif

                                    </td>
                                    <td class="table-report__action w-56">
                                        @if ($additional_services->additional_services_id != 0)
                                            <div class="flex justify-center items-center">
                                                <form action="{{ route('additional_service') }}" method="get">

                                                    <input hidden
                                                        value="{{ $additional_services->additional_services_id }}"
                                                        name="id">
                                                    <button class="button inline-block bg-theme-1 text-white"
                                                        type="submit"><i data-feather="eye"
                                                            class="w-4 h-4 mr-1"></i></button>
                                                </form>
                                                <form action="{{ route('additional_service') }}" method="get">

                                                    <input hidden
                                                        value="{{ $additional_services->additional_services_id }}"
                                                        name="id">
                                                    <button class="button inline-block bg-theme-1 text-white ml-1"
                                                        type="submit"><i class="fa fa-edit"
                                                            aria-hidden="true"></i></button>
                                                </form>
                                            </div>
                                        @endif
                                    </td>
                                </tr>
                                <?php $index++; ?>
                            @endforeach
                        @endif
                    </tbody id="body">
                </table>

            </div>
        </div>
    </div>


@endsection


@if (isset($status_info))

    <div>

        @section('text')
            <h2 style="display:inline;">Active</h2>
        @endsection

        @section('status_button')
            @if ($details->status)
                <input class="input input--switch ml-auto border act-status" name="stat" type="checkbox" checked>
            @else
                <input class="input input--switch ml-auto border act-status" name="stat" type="checkbox">
            @endif
        @endsection


        @section('additional-info')
            <p>Created By : {{ isset($status_info) ? $status_info['created_by'] : '' }}</p>
            <p>Created Date : {{ isset($status_info) ? $status_info['created_at'] : '' }}</p>
            <p>Updated By : {{ isset($status_info) ? $status_info['updated_by'] : '' }}</p>
            <p>Updated Date : {{ isset($status_info) ? $status_info['updated_at'] : '' }}</p>
        @endsection

    </div>

@endif

@section('script-area')


    <script>
        
        $(document).ready(function() {

            $('#dttbl').DataTable();
            
        });

        $(document).ready(function() {

            $('#save').attr('hidden',true);
            $('#clear').attr('hidden',false);
            $('#cancel').attr('hidden',false);

        });

        $('#savebtn').click(function() {


            $('#frmdt').validate({

                rules: {
                    job_name: {
                        required: true,
                        minlength: 3,
                    },
                    job_discription: {
                        required: true,
                        minlength: 3,
                    }
                },

                // relavant messages

                messages: {

                    job_name: "please enter a Job Type",
                    job_discription: "please enter a Job Discription",

                }

            });


            if ($('#frmdt').valid()) {
                $('#frmdt').submit();
            }

        });


        $(document).ready(function() {

            $('#cancel').hide();
        });
    </script>

@endsection
