@extends('../layout/home-layout')

@section('title', 'Additional Services Allocation ')

@section('home-content')

<div>
    <br>
    <button id="btnaddchange" name="btnaddchange" class="button text-white bg-theme-12 shadow-md mr-2" onclick="divopened()">View Outside Customer List
    </button>

</div>
<br><br>
<div class="grid grid-cols-12 gap-6 mt-5" id="divopened">
    <div class="intro-y col-span-12 flex flex-wrap sm:flex-no-wrap items-center mt-2">
        <a href="{{ route('additional_service_allocations_view_add_edit') }}" class="add-rate-link  mr-2 ml-auto"> <i data-feather="plus-circle" class="w-5 h-5 mr-1"> </i> Additional Services Add</a>
    </div>
    <br>
    <!-- BEGIN: Data List -->

    <div class="intro-y col-span-12 overflow-auto lg:overflow-visible">
        <table class="table table-report -mt-2" id="dttbl">
            <thead>
                <tr>
                    <th class="whitespace-no-wrap text-center">#</th>
                    <th class="text-center whitespace-no-wrap">Guest Name</th>
                    <th class="text-center whitespace-no-wrap">Service Type</th>
                    <th class="text-center whitespace-no-wrap">Number of Hours</th>
                    <th class="text-center whitespace-no-wrap">Number of Items</th>
                    <th class="text-center whitespace-no-wrap">Date/Time</th>
                    <th class="text-center whitespace-no-wrap"> Action</th>
                </tr>
            </thead>
            <tbody id="data_table">
                @if (count($Additional_Service_Allocation) > 0)
                @foreach ($Additional_Service_Allocation as $Additional_Service_Allocation)
                <tr class="intro-x">
                    <td>
                        <div class="font-medium whitespace-no-wrap text-center">
                            {{ $Additional_Service_Allocation->allocations_id }}
                        </div>
                    </td>
                    <td>
                        <div class="font-medium whitespace-no-wrap text-center">
                            {{ $Additional_Service_Allocation->Reservation_Details->get_guest->guestFname }}&nbsp;&nbsp;{{ $Additional_Service_Allocation->Reservation_Details->get_guest->guestLname }}
                        </div>
                    </td>
                    <td>
                        @foreach ($Additional_Service_Allocation->Alocation_Details as $AlocationDetails)
                        @foreach ($AlocationDetails->Additional_Services as $AdditionalServices)
                        <div class="font-medium whitespace-no-wrap ">
                            {{ $AdditionalServices->additional_services_name }}
                        </div>
                        @endforeach
                        @endforeach
                    </td>
                    <td>
                        @foreach ($Additional_Service_Allocation->Alocation_Details as $AlocationDetails)
                        <div class="font-medium whitespace-no-wrap text-center">
                            {{ $AlocationDetails->duration }}
                        </div>
                        @endforeach
                    </td>
                    <td>
                        @foreach ($Additional_Service_Allocation->Alocation_Details as $AlocationDetails)
                        <div class="font-medium whitespace-no-wrap text-center">
                            {{ $AlocationDetails->count }}
                        </div>
                        @endforeach
                    </td>
                    <td>
                        @foreach ($Additional_Service_Allocation->Alocation_Details as $AlocationDetails)
                        <div class="font-medium whitespace-no-wrap text-center">
                            {{ $AlocationDetails->allocations_date_date }}
                        </div>
                        @endforeach
                    </td>
                    <td class="table-report__action w-56">
                        @foreach ($Additional_Service_Allocation->Alocation_Details as $AlocationDetails)
                        @if ($Additional_Service_Allocation->allocations_id != 0)

                        <div class="flex justify-center items-center">
                            <form action="{{ route('additional_service_allocations_view_add_edit') }}" method="get">
                                <input hidden value="{{ $AlocationDetails->allocations_id }}" name="id" id="id">
                                <input hidden value="{{ $AlocationDetails->additional_services_id }}" name="asid" id="asid">
                                <input hidden value="{{ $AlocationDetails->allocations_keeps_id }}" name="aid" id="asid">
                                <button  class="flex items-center mr-3 text-theme-1" type="submit"><i data-feather="eye" class="w-4 h-4 mr-1"></i>View</button>
                            </form>
                            <form action="{{ route('additional_service_allocations_view_add_edit') }}" method="get">
                                <input hidden value="{{ $AlocationDetails->allocations_id }}" name="id" id="id">
                                <input hidden value="{{ $AlocationDetails->additional_services_id }}" name="asid" id="asid">
                                <input hidden value="{{ $AlocationDetails->allocations_keeps_id }}" name="aid" id="asid">
                                <button class="flex items-center mr-3 text-theme-1" type="submit"><i data-feather="check-square" class="w-4 h-4 mr-1"></i>Edit</button>
                            </form>
                        </div>
                        @endif
                        @endforeach

                    </td>
                </tr>
                @endforeach
                @endif
            </tbody id="body">
        </table>

    </div>
</div>
{{-- out-side customer details --}}
<div class="grid grid-cols-12 gap-6 mt-5" id="divclosed">
    <div class="intro-y col-span-12 flex flex-wrap sm:flex-no-wrap items-center mt-2">

        <a href="javascript:;" data-toggle="modal" data-target="#guest_modal" class=" button text-white bg-theme-1 shadow-md mr-2" hidden>Add Cutomer</a>
        <a href="{{ route('additional_service_allocations_add_edit_outsiders') }}" class="button text-white bg-theme-1 shadow-md mr-2">Additional Services Add</a>
    </div>
    <br>
    <!-- BEGIN: Data List -->

    <div class="intro-y col-span-12 overflow-auto lg:overflow-visible">
        <table class="table table-report -mt-2" id="dttbl">
            <thead>
                <tr>
                    <th class="whitespace-no-wrap text-center">#</th>
                    <th class="text-center whitespace-no-wrap">Guest Name</th>
                    <th class="text-center whitespace-no-wrap">Service Type</th>
                    {{-- <th class="text-center whitespace-no-wrap">Hours</th>
                        <th class="text-center whitespace-no-wrap">Items</th> --}}
                    <th class="text-center whitespace-no-wrap">Date/Time</th>
                    <th class="text-center whitespace-no-wrap">Deposit Type</th>
                    <th class="text-center whitespace-no-wrap">Deposit</th>
                    <th class="text-center whitespace-no-wrap"> Action</th>
                    <th class="text-center whitespace-no-wrap"> Payment</th>
                </tr>
            </thead>
            <tbody id="data_table">
                @if (count($Additional_Service_Allocation_with_outSider) > 0)
                @foreach ($Additional_Service_Allocation_with_outSider as $Additional_Service_outSider)
                <tr class="intro-x">
                    <td>
                        <div class="font-medium whitespace-no-wrap text-center">
                            {{ $Additional_Service_outSider->allocations_id_outsiders }}
                        </div>
                    </td>
                    <td>
                        <div class="font-medium whitespace-no-wrap text-center">
                            {{ $Additional_Service_outSider->GetOutSideCustomer->customer_first_name }}&nbsp;&nbsp;{{ $Additional_Service_outSider->GetOutSideCustomer->customer_last_name }}
                        </div>
                    </td>
                    <td>
                        @foreach ($Additional_Service_outSider->Alocation_Details_OutSiders as $AlocationDetails)
                        @foreach ($AlocationDetails->Additional_Services as $AdditionalServices)
                        <div class="font-medium whitespace-no-wrap ">
                            {{ $AdditionalServices->additional_services_name }}
                        </div>
                        @endforeach
                        @endforeach
                    </td>
                    {{-- <td>
                                @foreach ($Additional_Service_outSider->Alocation_Details_OutSiders as $AlocationDetails)
                                    <div class="font-medium whitespace-no-wrap text-center">
                                        {{ $AlocationDetails->duration }}
    </div>
    @endforeach
    </td>
    <td>
        @foreach ($Additional_Service_outSider->Alocation_Details_OutSiders as $AlocationDetails)
        <div class="font-medium whitespace-no-wrap text-center">
            {{ $AlocationDetails->count }}
        </div>
        @endforeach
    </td> --}}
    <td>
        @foreach ($Additional_Service_outSider->Alocation_Details_OutSiders as $Alocation_Details_OutSiders)
        <div class="font-medium whitespace-no-wrap text-center">
            {{ $AlocationDetails->allocations_date_date }}
        </div>
        @endforeach
    </td>

    <td>
        <div class="font-medium whitespace-no-wrap text-center">
            @if ($Additional_Service_outSider->diposit_type == 0)
            No Disposition
            @endif
            @if ($Additional_Service_outSider->diposit_type == 1)
            National Identity Card
            @endif
            @if ($Additional_Service_outSider->diposit_type == 2)
            Passport
            @endif
            @if ($Additional_Service_outSider->diposit_type == 3)
            Driving License
            @endif
        </div>
    </td>
    <td>
        <div class="font-medium whitespace-no-wrap text-center">
            @if ($Additional_Service_outSider->diposit_amount == 0)
            No Disposition
            @else
            {{ $Additional_Service_outSider->diposit_amount }}
            @endif
        </div>
    </td>

    <td class="table-report__action w-56">
        @foreach ($Additional_Service_outSider->Alocation_Details_OutSiders as $AlocationDetails)
        @if ($Additional_Service_outSider->allocations_id_outsiders != 0)

        <div class="flex justify-center items-center">
            <form action="{{ route('additional_service_allocations_add_edit_outsiders') }}" method="get">
                <input hidden value="{{ $AlocationDetails->allocations_id }}" name="cid" id="cid">
                <input hidden value="{{ $AlocationDetails->additional_services_id }}" name="casid" id="casid">
                <input hidden value="{{ $AlocationDetails->allocations_keeps_id }}" name="caid" id="casid">
                <button  class="flex items-center mr-3 text-theme-1" type="submit"><i data-feather="eye" class="w-4 h-4 mr-1"></i>View</button>
            </form>
            <form action="{{ route('additional_service_allocations_add_edit_outsiders') }}" method="get">
                <input hidden value="{{ $AlocationDetails->allocations_id }}" name="cid" id="cid">
                <input hidden value="{{ $AlocationDetails->additional_services_id }}" name="casid" id="casid">
                <input hidden value="{{ $AlocationDetails->allocations_keeps_id }}" name="caid" id="casid">
                <button  class="flex items-center mr-3 text-theme-1" type="submit"><i data-feather="check-square" class="w-4 h-4 mr-1"></i>Edit</button>
            </form>
        </div>
        @endif
        @endforeach

    </td>
    <td>
        <div class="flex justify-center items-center">
            <form action="{{ route('additional_service_allocations_print') }}" method="get">
                <input hidden value="{{ $AlocationDetails->allocations_id }}" name="cid" id="cid">
                <input hidden value="{{ $AlocationDetails->additional_services_id }}" name="casid" id="casid">
                <input hidden value="{{ $AlocationDetails->allocations_keeps_id }}" name="cakid" id="cakid">
                <button  class="flex items-center mr-3 text-theme-9" type="submit"><i data-feather="eye" class="w-4 h-4 mr-1"></i>view</button>
            </form>
        </div>
        <div class="flex justify-center items-center">
            <form action="{{ route('print_pdf') }}" method="post">
                @csrf
                <input hidden value="{{ $AlocationDetails->allocations_id }}" name="cid" id="cid">
                <input hidden value="{{ $AlocationDetails->additional_services_id }}" name="casid" id="casid">
                <input hidden value="{{ $AlocationDetails->allocations_keeps_id }}" name="cakid" id="cakid">
                <button  class="flex items-center mr-3 text-theme-9" type="submit"><i data-feather="printer" class="w-4 h-4 mr-1"></i>Print</button>
            </form>
        </div>

    </td>

    </tr>
    @endforeach
    @endif
    </tbody id="body">
    </table>

</div>

</div>
<div class="modal" id="guest_modal">
    <div class="modal__content">
        <div class="flex items-center px-5 py-5 sm:py-3 border-b border-gray-200 dark:border-dark-5">
            <h2 class="font-medium text-base mr-auto">Customer Information</h2>
            <div class="dropdown sm:hidden">
                <a class="dropdown-toggle w-5 h-5 block" href="javascript:;">
                    <i data-feather="more-horizontal" class="w-5 h-5 text-gray-700 dark:text-gray-600"></i>
                </a>
            </div>
        </div>
        <form id="guest_form" action="{{ route('additional_service_Customer_addd')}}" method="POST">
            @csrf
            <div class="p-5 grid grid-cols-12 gap-4 row-gap-3">
                <div class="col-span-12 sm:col-span-6">
                    <label>First Nae</label>
                    <input type="text" id="fname" name="fname" required class="input w-full border mt-2 flex-1" placeholder="sam">
                </div>
                <div class="col-span-12 sm:col-span-6">
                    <label>Last Name</label>
                    <input type="text" id="lname" name="lname" required class="input w-full border mt-2 flex-1" placeholder="smith">
                </div>
                <div class="col-span-12 sm:col-span-6">
                    <label>ID Card Number</label>
                    <input type="text" id="id_number" name="id_number" class="input w-full border mt-2 flex-1">
                </div>
                <div class="col-span-12 sm:col-span-6">
                    <label>Contact No</label>
                    <input type="tel" id="Cnumber" name="Cnumber" required class="input w-full border mt-2 flex-1">
                </div>
                <div class="col-span-12 sm:col-span-12">
                    <label>Email</label>
                    <input type="text" id="Cemail" name="Cemail" minlength="9" required class="input w-full border mt-2 flex-1">
                </div>
            </div>
            <div class="px-5 py-3 text-right border-t border-gray-200 dark:border-dark-5">
                <button type="button" data-dismiss="modal" class="button w-20 border text-gray-700 dark:border-dark-5 dark:text-gray-300 mr-1">Cancel</button>
                <button type="submit" class="button w-20 bg-theme-1 text-white">Save</button>
            </div>
        </form>

    </div>
</div>
@extends('includes.links')
@if ($errors->any())
@foreach ($errors->all() as $error)

<script>
    $(document).ready(function() {
        Toastify({
            text: "{{ $error }}",
            duration: 5000,
            newWindow: true,
            close: true,
            gravity: "bottom",
            position: "left",
            backgroundColor: "#0e2c88",
            stopOnFocus: true
        }).showToast();

    });
</script>

@endforeach
@endif
<script type="text/javascript">

$(document).ready( function () {
    $('#dttbl').DataTable();
} );

    $(document).ready(function() {


        $("#Search_Input").on("keyup", function() {
            var value = $(this).val().toLowerCase();
            $("#data_table tr").filter(function() {
                $(this).toggle($(this).text().toLowerCase().indexOf(value) > -1)
            });
        });
    });

    function submitfrm() {
        $('#guest_form').submit();
    }


    window.onload = function() {
        document.getElementById("divclosed").style.display = 'none';
    };

    function divopened() {
        var btntxt = document.getElementById("btnaddchange");
        var indide = document.getElementById("divopened");
        var outside = document.getElementById("divclosed");
        if (indide.style.display === "none") {
            indide.style.display = "block";
            outside.style.display = "none";
            btntxt.innerHTML = "View Outside Customer List"
        } else {
            indide.style.display = "none";
            outside.style.display = "block";
            btntxt.innerHTML = "View Inside Customer List"
        }
    }
</script>
@endsection