@extends('../layout/home-layout')

@section('title', '')

@section('home-content')

    <div class="grid grid-cols-12 gap-6 mt-5">


        <div class="intro-y col-span-12 flex flex-wrap sm:flex-no-wrap items-center mt-2">
            @csrf
            <button class="button text-white bg-theme-1 shadow-md mr-2" type="submit" onclick="history.back()""
                        value=" Print">Back
            </button>
            </form>
        </div>
    </div>
    <div class="intro-y box overflow-hidden mt-5" id="receipt">
        <div class="flex flex-col lg:flex-row pt-10 px-5 sm:px-20 sm:pt-20 lg:pb-20 text-center sm:text-left">
            <div class="font-semibold text-theme-1 dark:text-theme-10 text-3xl">INVOICE</div>
            <div class="mt-20 lg:mt-0 lg:ml-auto lg:text-right">
                <div class="text-xl text-theme-1 dark:text-theme-10 font-medium">Hotel Name</div>
                <div class="mt-1">hotelemail@gmail.com</div>
                <div class="mt-1">hotel adress</div>
            </div>
        </div>
        <div class="flex flex-col lg:flex-row border-b px-5 sm:px-20 pt-10 pb-10 sm:pb-20 text-center sm:text-left">
            <div>
                <div class="text-base text-gray-600">Client Details</div>
                <div class="text-lg font-medium text-theme-1 dark:text-theme-10 mt-2">
                    {{ isset($AdditionalServiceAllocation_with_outSider)? $AdditionalServiceAllocation_with_outSider->GetOutSideCustomer->customer_first_name: ' ' }}
                    {{ isset($AdditionalServiceAllocation_with_outSider)? $AdditionalServiceAllocation_with_outSider->GetOutSideCustomer->customer_last_name: ' ' }}
                </div>
                <div class="mt-1">
                    {{ isset($AdditionalServiceAllocation_with_outSider)? $AdditionalServiceAllocation_with_outSider->GetOutSideCustomer->customer_contact_number: ' ' }}
                </div>
                <div class="mt-1">
                    {{ isset($AdditionalServiceAllocation_with_outSider)? $AdditionalServiceAllocation_with_outSider->GetOutSideCustomer->customer_address: ' ' }}
                </div>
            </div>
            <div class="mt-10 lg:mt-0 lg:ml-auto lg:text-right">
                <div class="text-base text-gray-600">Receipt</div>
                <div class="text-lg text-theme-1 dark:text-theme-10 font-medium mt-2">#1</div>
                <div class="mt-1">{{ date('Y-m-d H:i:s') }}</div>
            </div>
        </div>
        <div class="px-5 sm:px-16 py-10 sm:py-20">
            <div class="overflow-x-auto">
                <table class="table">
                    <thead>
                        <tr>

                            <th class="border-b-2 dark:border-dark-5 whitespace-no-wrap">Service</th>
                            <th class="border-b-2 dark:border-dark-5 text-center whitespace-no-wrap">Number of Hours</th>
                            <th class="border-b-2 dark:border-dark-5 text-right whitespace-no-wrap">Number of Items</th>
                            <th class="border-b-2 dark:border-dark-5 text-center whitespace-no-wrap">Unit Price</th>
                            <th class="border-b-2 dark:border-dark-5 text-center whitespace-no-wrap">SUBTOTAL</th>
                        </tr>
                    </thead>
                    <tbody>
                        @php
                            $index = 0;
                        @endphp
                        @foreach ($AdditionalServiceAllocation_with_outSider->Alocation_Details_OutSiders as $Additional_Service_outSider)
                            <tr>
                                <td class="text-left border-b dark:border-dark-5 w-32">
                                    @foreach ($Additional_Service_outSider->Additional_Services as $Additional_Services)
                                        <div class="font-medium whitespace-no-wrap ">
                                            {{ $Additional_Services->additional_services_name }}
                                        </div>
                                    @endforeach
                                </td>
                                <td class="text-center border-b dark:border-dark-5 w-32 font-medium">
                                    {{ $Additional_Service_outSider->duration }}</td>
                                <td class="text-center border-b dark:border-dark-5 w-32 font-medium">
                                    {{ $Additional_Service_outSider->count }}</td>
                                <td class="text-center border-b dark:border-dark-5 w-32 font-medium">
                                    @foreach ($Additional_Service_outSider->Additional_Services as $Additional_Services)
                                        <div class="font-medium whitespace-no-wrap ">
                                            Rs.{{ $Additional_Services->additional_services_price }}.00
                                        </div>
                                    @endforeach
                                </td>
                                <td class="text-center border-b dark:border-dark-5 w-32 font-medium">
                                    Rs.{{ $subtotal[$index] }}.00
                                </td>
                            </tr>
                            @php
                                $index++;
                            @endphp
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>

        <div class="px-5 sm:px-20 pb-10 sm:pb-20 flex flex-col-reverse sm:flex-row">

            <div class="text-center sm:text-left mt-10 sm:mt-0">
                <div class="text-base text-gray-600">Deposit Amount</div>
                <div class="text-lg text-theme-1 dark:text-theme-10 font-medium mt-2">Rs:
                    {{ isset($AdditionalServiceAllocation_with_outSider)? $AdditionalServiceAllocation_with_outSider->diposit_amount: ' ' }}.00
                </div>
                <div class="mt-1">Deposit :
                    @if ($AdditionalServiceAllocation_with_outSider->diposit_type == 0)
                        No Disposition
                    @endif
                    @if ($AdditionalServiceAllocation_with_outSider->diposit_type == 1)
                        National Identity Card
                    @endif
                    @if ($AdditionalServiceAllocation_with_outSider->diposit_type == 2)
                        Passport
                    @endif
                    @if ($AdditionalServiceAllocation_with_outSider->diposit_type == 3)
                        Driving License
                    @endif
                </div>
            </div>
            <div class="text-center sm:text-right sm:ml-auto">
                <div class="text-base text-gray-600" style="font-size: 12px">Total</div>
                <div class="text-xl text-theme-1 dark:text-theme-10 font-medium mt-2" style="font-size: 15px">
                    Rs.{{ $total }}.00</div>
                <br>
                <div class="text-base text-gray-600">Total With Deposit</div>
                <div class="text-xl text-theme-1 dark:text-theme-10 font-medium mt-2"> Rs.{{ $totalwithdiscount }}.00
                </div>
            </div>
        </div>
    </div>

    @extends('includes.links')
    @if ($errors->any())
        @foreach ($errors->all() as $error)
            <script>
                $(document).ready(function() {
                    Toastify({
                        text: "{{ $error }}",
                        duration: 5000,
                        newWindow: true,
                        close: true,
                        gravity: "bottom",
                        position: "left",
                        backgroundColor: "#0e2c88",
                        stopOnFocus: true
                    }).showToast();

                });
            </script>
        @endforeach
    @endif
    <script type="text/javascript">
        $(document).ready(function() {
            $('#dttbl').DataTable();
        });
        $(document).ready(function() {
            $("#Search_Input").on("keyup", function() {
                var value = $(this).val().toLowerCase();
                $("#data_table tr").filter(function() {
                    $(this).toggle($(this).text().toLowerCase().indexOf(value) > -1)
                });
            });
        });


        function print() {
            var elem = document.getElementById("receipt").innerHTML;
            document.getElementById("hiddenhtml").value = elem;
        }
    </script>
@endsection
