@extends('../layout/form-home-layout')

@section('form-name', 'Additional Services Allocation')

@section('form-area')



<div class="p-5" id="form-validation">
    <form class="validate-form" id="frmdt" method="POST" action="{{ route('additional_service_allocationsUpdate_update_add_edit') }}">
        @csrf
        <input name="allKeepId" id="allKeepId" type="text"  hidden
        class="input w-full border flex-1" placeholder="0"
        value="{{ isset($Additional_Keep_With_ID) ? $Additional_Keep_With_ID->allocations_keeps_id : '' }}">
    
        <input name="allallocationid" id="allallocationid" type="text"  hidden
        class="input w-full border flex-1" placeholder="0"
        value="{{ isset($Additional_Keep_With_ID) ? $Additional_Keep_With_ID->allocations_id : '' }}">
        <input name="Gusst_idd" id="Gusst_idd" type="text"  hidden
        class="input w-full border flex-1" placeholder="0"
        value="{{ isset($Additional_Service_Allocation_With_ID) ? $Additional_Service_Allocation_With_ID->Reservation_Details->get_guest->id : '' }}">
        <div class="grid grid-cols-12 gap-5">
            <div class="col-span-12 ">
                    <div class="intro-y col-span-12 sm:col-span-6 input-form w-full">
                        <div class="mb-2">Guest</div>
                        
                        <select  
                        @if (isset($Additional_Service_Allocation_With_ID))
                            disabled
                        @endif
                        class="input w-full border flex-1 js-example-basic-single" id="Additional_Service_Guest" name="Additional_Service_Guest">

                            
                            <option  value="{{ isset($Additional_Service_Allocation_With_ID) ? $Additional_Service_Allocation_With_ID->Reservation_Details->get_guest->id : '' }}">
                                {{ isset($Additional_Service_Allocation_With_ID) ? $Additional_Service_Allocation_With_ID->Reservation_Details->get_guest->guestFname : ' --Select ' }}
                                {{ isset($Additional_Service_Allocation_With_ID) ? $Additional_Service_Allocation_With_ID->Reservation_Details->get_guest->guestLname : ' ' }}
                                 -- {{ isset($Additional_Service_Allocation_With_ID) ? $Additional_Service_Allocation_With_ID->Reservation_Details->get_guest->guestEmail : ' ' }}
                                 {{ isset($Additional_Service_Allocation_With_ID) ? $Additional_Service_Allocation_With_ID->Reservation_Details->get_guest->contactNo : ' ' }}
                            </option>
                            @foreach ($guest as $raw)
                                <option value="{{ isset($guest) ? $raw->id : '' }}">
                                    {{ isset($guest) ? $raw->guestFname : '' }}
                                    {{ isset($guest) ? $raw->guestLname : '' }}
                                    / {{ isset($guest) ? $raw->guestEmail : '' }}
                                    / {{ isset($guest) ? $raw->contactNo : '' }}
                                </option>
                            @endforeach
                        </select>
                    </div>

                
                    <div class="intro-y col-span-12 sm:col-span-6 input-form"><br>
                        <div class="mb-2">Additional Services Types</div>
                        <select class="input w-full border flex-1 js-example-basic-single" id="Additional_Service_Name" name="Additional_Service_Name">
                            <option value="{{ isset($Additional_Service_with_ID) ? $Additional_Service_with_ID->additional_services_id : '' }}">
                                {{ isset($Additional_Service_with_ID) ? $Additional_Service_with_ID->additional_services_name : ' --Select-- ' }}</option>
                            @foreach ($Additional_Service as $raw)
                                <option value="{{ isset($Additional_Service) ? $raw->additional_services_id : '' }}">
                                    {{ isset($Additional_Service) ? $raw->additional_services_name : '' }}
                                </option> 
                            @endforeach

                        </select>
                    </div>
                <div class="grid grid-cols-12 gap-4 row-gap-5 mt-5">
                    <div class="intro-y col-span-12 sm:col-span-6 input-form">
                        <div class="mb-2">Number of Hours</div>
                        <input name="Additional_Hours" id="Additional_Hours" type="number" required
                            class="input w-full border flex-1" placeholder="0"
                            value="{{ isset($Additional_Keep_With_ID) ? $Additional_Keep_With_ID->duration : '' }}">
                    </div>
                    <div class="intro-y col-span-12 sm:col-span-6 input-form">
                        <div class="mb-2">Number of Items</div>
                        <input name="Additional_Items" id="Additional_Items" type="number" required class="input w-full border flex-1"
                            placeholder="0" value="{{ isset($Additional_Keep_With_ID) ? $Additional_Keep_With_ID->count : '' }}">
                    </div>
                </div>
                
                <div class="grid grid-cols-12 gap-4 row-gap-5 mt-5">

                        <div class="intro-y col-span-12 sm:col-span-12 input-form">
                            <div class="mb-2">Allocation </div>
                            <input name="Additional_Date" id="Additional_Date" type="datetime-local" required
                                class="input w-full border flex-1" placeholder="0"
                                value="{{ isset($Additional_Keep_With_ID) ? $Additional_Keep_With_ID->allocations_date_date : '' }}">
                        </div>
                </div>

                <div class="intro-y col-span-12 sm:col-span-6 input-form">
                    <br>
                    <div class="mb-2">Description</div>
                    <textarea name="Additional_Descriptione" id="Additional_Descriptione"
                        class="input w-full border mt-2 bg-gray-100"
                        placeholder="">{{ isset($Additional_Keep_With_ID) ? $Additional_Keep_With_ID->Description : '' }}</textarea>
                </div>


            </div>
        </div>

    </form>
</div>

@endsection


@section('table-area')

    <div class="intro-y col-span-12 overflow-auto lg:overflow-visible">
        <table class="table table-report -mt-2" id="dttbl">
            <thead>
                <tr>
                    <th class="whitespace-no-wrap ">#</th>
                        <th class=" whitespace-no-wrap">Guest Name</th>
                        <th class=" whitespace-no-wrap">Service Type</th>
                </tr>
            </thead>
            <tbody id="data_table">
                @if (count($Additional_Service_Allocation) > 0) 
                    @foreach ($Additional_Service_Allocation as $Additional_Service_Allocation)

                        <tr class="intro-x">
                            <td>
                                <div class="font-medium whitespace-no-wrap ">{{ $Additional_Service_Allocation->allocations_id }}</div>
                            </td>
                            <td>
                                <div class="font-medium whitespace-no-wrap ">{{ $Additional_Service_Allocation->Reservation_Details->get_guest->guestFname }}&nbsp;&nbsp;{{ $Additional_Service_Allocation->Reservation_Details->get_guest->guestLname }}</div>
                            </td>
                            <td>
                                @foreach ($Additional_Service_Allocation->Alocation_Details as $AlocationDetails)
                                     @foreach ($AlocationDetails->Additional_Services as $AdditionalServices)
                                         <div class="font-medium whitespace-no-wrap ">{{ $AdditionalServices->additional_services_name}}  ({{ $AlocationDetails->duration}} / {{ $AlocationDetails->count}})
                                        </div>
                                     @endforeach
                                @endforeach
                            </td>
                        </tr>
                    @endforeach
                @endif
            </tbody id="body">
        </table>

    </div>

@endsection


@if (isset($status_info))

    <div>

        @section('text')

            <h2 style="display:inline;">Active</h2>

        @endsection

        @section('status_button')

            @if ($details->status)
                <input class="input input--switch ml-auto border act-status" name="stat" type="checkbox" checked>
            @else
                <input class="input input--switch ml-auto border act-status" name="stat" type="checkbox">
            @endif

        @endsection


        @section('additional-info')

            <p>Created By : {{ isset($status_info) ? $status_info['created_by'] : '' }}</p>
            <p>Created Date : {{ isset($status_info) ? $status_info['created_at'] : '' }}</p>
            <p>Updated By : {{ isset($status_info) ? $status_info['updated_by'] : '' }}</p>
            <p>Updated Date : {{ isset($status_info) ? $status_info['updated_at'] : '' }}</p>

        @endsection

    </div>

@endif

@section('script-area')


    <script>
        $('#save').click(function() {


            $('#frmdt').validate({

                rules: {
                    Additional_Service_Guest: {
                        required: true,
                    },
                    Additional_Service_Name: {
                        required: true,
                    },
                    Additional_Hours: {
                        required: true,
                    },
                    Additional_Items: {
                        required: true,
                    },
                    Additional_Date: {
                        required: true,
                    },
                    Additional_Time: {
                        required: true,
                    },
                    Additional_Descriptione: {
                        required: true,
                    }
                },

                // relavant messages

                messages: {

                    Additional_Service_Guest: "please enter a Job Type",
                    Additional_Service_Name: "please enter a Job Discription",
                    Additional_Hours: "please enter a Job Type",
                    Additional_Keep_Items: "please enter a Job Discription",
                    Additional_Date: "please enter a Job Type",
                    Additional_Keep_Time: "please enter a Job Discription",
                    Additional_Keep_Descriptione: "please enter a Job Type"

                }

            });


            if ($('#frmdt').valid()) {
                $('#frmdt').submit();
            }

        });


        $(document).ready(function() {
            $("#btn2").click(function() {
                $("ol").append(
                    '<li><br><div class="intro-y col-span-12 sm:col-span-6 input-form"><input type="text" id="Sub_jobs" name="Sub_jobs[]" class="input w-full border flex-1"placeholder="Sub Job"></div></li>'
                );
            });

            $("#btn3").click(function() {
                $("li:last").remove();
            });
        });
    </script>

    <script>
    $(document).ready(function() {
        $('.js-example-basic-single').select2();
    });
    </script>
@endsection
